Ext.data.JsonP.sol_notify_as_Utils({"tagname":"class","name":"sol.notify.as.Utils","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"lib_sol.notify.as.Utils.js","href":"lib_sol.notify.as.Utils.html#sol-notify-as-Utils"}],"author":[{"tagname":"author","name":"JHR, ELO Digital Office GmbH","email":null}],"version":["1.00.000"],"eloas":true,"requires":["sol.common.Config","sol.common.DateUtils","sol.common.HttpUtils","sol.common.ObjectFormatter.TemplateSord","sol.common.ObjectFormatter.TemplateTask","sol.common.RepoUtils","sol.common.Template","sol.common.WfUtils","sol.common.as.functions.SendMail","sol.notify.Utils"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"sessionLanguage","tagname":"property","owner":"sol.notify.as.Utils","id":"property-sessionLanguage","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"createMailNotifyBody","tagname":"method","owner":"sol.notify.as.Utils","id":"method-createMailNotifyBody","meta":{}},{"name":"getFeedAggregation","tagname":"method","owner":"sol.notify.as.Utils","id":"method-getFeedAggregation","meta":{}},{"name":"getMailAddress","tagname":"method","owner":"sol.notify.as.Utils","id":"method-getMailAddress","meta":{}},{"name":"getPictureUrl","tagname":"method","owner":"sol.notify.as.Utils","id":"method-getPictureUrl","meta":{}},{"name":"getPictureUserName","tagname":"method","owner":"sol.notify.as.Utils","id":"method-getPictureUserName","meta":{}},{"name":"getPictures","tagname":"method","owner":"sol.notify.as.Utils","id":"method-getPictures","meta":{}},{"name":"getSordInfo","tagname":"method","owner":"sol.notify.as.Utils","id":"method-getSordInfo","meta":{}},{"name":"getSordMap","tagname":"method","owner":"sol.notify.as.Utils","id":"method-getSordMap","meta":{}},{"name":"getTemplateSordInstance","tagname":"method","owner":"sol.notify.as.Utils","id":"method-getTemplateSordInstance","meta":{}},{"name":"getTemplateTaskInstance","tagname":"method","owner":"sol.notify.as.Utils","id":"method-getTemplateTaskInstance","meta":{}},{"name":"getText","tagname":"method","owner":"sol.notify.as.Utils","id":"method-getText","meta":{}},{"name":"getUserName","tagname":"method","owner":"sol.notify.as.Utils","id":"method-getUserName","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"isOverTimeLimit","tagname":"method","owner":"sol.notify.as.Utils","id":"method-isOverTimeLimit","meta":{}},{"name":"loadReportFlags","tagname":"method","owner":"sol.notify.as.Utils","id":"method-loadReportFlags","meta":{}},{"name":"loadUserLanguage","tagname":"method","owner":"sol.notify.as.Utils","id":"method-loadUserLanguage","meta":{}},{"name":"prepareFindTasksInfo","tagname":"method","owner":"sol.notify.as.Utils","id":"method-prepareFindTasksInfo","meta":{}},{"name":"prepareTask","tagname":"method","owner":"sol.notify.as.Utils","id":"method-prepareTask","meta":{}},{"name":"processAllUsers","tagname":"method","owner":"sol.notify.as.Utils","id":"method-processAllUsers","meta":{}},{"name":"processNotifyMail","tagname":"method","owner":"sol.notify.as.Utils","id":"method-processNotifyMail","meta":{}},{"name":"processTask","tagname":"method","owner":"sol.notify.as.Utils","id":"method-processTask","meta":{}},{"name":"processUser","tagname":"method","owner":"sol.notify.as.Utils","id":"method-processUser","meta":{}},{"name":"sendNotifyMail","tagname":"method","owner":"sol.notify.as.Utils","id":"method-sendNotifyMail","meta":{}}],"code_type":"ext_define","singleton":true,"id":"class-sol.notify.as.Utils","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.notify.as.Utils</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.Config' rel='sol.common.Config' class='docClass'>sol.common.Config</a></div><div class='dependency'><a href='#!/api/sol.common.DateUtils' rel='sol.common.DateUtils' class='docClass'>sol.common.DateUtils</a></div><div class='dependency'><a href='#!/api/sol.common.HttpUtils' rel='sol.common.HttpUtils' class='docClass'>sol.common.HttpUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ObjectFormatter.TemplateSord' rel='sol.common.ObjectFormatter.TemplateSord' class='docClass'>sol.common.ObjectFormatter.TemplateSord</a></div><div class='dependency'><a href='#!/api/sol.common.ObjectFormatter.TemplateTask' rel='sol.common.ObjectFormatter.TemplateTask' class='docClass'>sol.common.ObjectFormatter.TemplateTask</a></div><div class='dependency'><a href='#!/api/sol.common.RepoUtils' rel='sol.common.RepoUtils' class='docClass'>sol.common.RepoUtils</a></div><div class='dependency'><a href='#!/api/sol.common.Template' rel='sol.common.Template' class='docClass'>sol.common.Template</a></div><div class='dependency'><a href='#!/api/sol.common.WfUtils' rel='sol.common.WfUtils' class='docClass'>sol.common.WfUtils</a></div><div class='dependency'><a href='#!/api/sol.common.as.functions.SendMail' rel='sol.common.as.functions.SendMail' class='docClass'>sol.common.as.functions.SendMail</a></div><div class='dependency'><a href='#!/api/sol.notify.Utils' rel='sol.notify.Utils' class='docClass'>sol.notify.Utils</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.notify.as.Utils.html#sol-notify-as-Utils' target='_blank'>lib_sol.notify.as.Utils.js</a></div></pre><div class='doc-contents'><p>ELO Notification Services Library methods for the ELOas.</p>\n      <p class='version-tag'>Version: <b>1.00.000</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n</div></div></div><div id='property-sessionLanguage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.notify.as.Utils'>sol.notify.as.Utils</span><br/><a href='source/lib_sol.notify.as.Utils.html#sol-notify-as-Utils-property-sessionLanguage' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.notify.as.Utils-property-sessionLanguage' class='name expandable'>sessionLanguage</a> : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>&quot;en&quot;</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-createMailNotifyBody' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.notify.as.Utils'>sol.notify.as.Utils</span><br/><a href='source/lib_sol.notify.as.Utils.html#sol-notify-as-Utils-method-createMailNotifyBody' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.notify.as.Utils-method-createMailNotifyBody' class='name expandable'>createMailNotifyBody</a>( <span class='pre'>templateNotification, titleReport, notifyTasks, notifyPosts, notifyEmpty, emptyIcon</span> ) : string<span class=\"signature\"></span></div><div class='description'><div class='short'>Create HTML-Mail Body (for debugging) ...</div><div class='long'><p>Create HTML-Mail Body (for debugging)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>templateNotification</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>titleReport</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>notifyTasks</span> : String[]<div class='sub-desc'>\n</div></li><li><span class='pre'>notifyPosts</span> : String[]<div class='sub-desc'>\n</div></li><li><span class='pre'>notifyEmpty</span> : Boolean<div class='sub-desc'>\n</div></li><li><span class='pre'>emptyIcon</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>string</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getFeedAggregation' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.notify.as.Utils'>sol.notify.as.Utils</span><br/><a href='source/lib_sol.notify.as.Utils.html#sol-notify-as-Utils-method-getFeedAggregation' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.notify.as.Utils-method-getFeedAggregation' class='name expandable'>getFeedAggregation</a>( <span class='pre'>userId</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Get feed aggregation ...</div><div class='long'><p>Get feed aggregation</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>userId</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getMailAddress' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.notify.as.Utils'>sol.notify.as.Utils</span><br/><a href='source/lib_sol.notify.as.Utils.html#sol-notify-as-Utils-method-getMailAddress' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.notify.as.Utils-method-getMailAddress' class='name expandable'>getMailAddress</a>( <span class='pre'>userId</span> ) : string<span class=\"signature\"></span></div><div class='description'><div class='short'>Reads the configured mail address to an ELO user ...</div><div class='long'><p>Reads the configured mail address to an ELO user</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>userId</span> : String<div class='sub-desc'><p>ELO user</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>string</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getPictureUrl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.notify.as.Utils'>sol.notify.as.Utils</span><br/><a href='source/lib_sol.notify.as.Utils.html#sol-notify-as-Utils-method-getPictureUrl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.notify.as.Utils-method-getPictureUrl' class='name expandable'>getPictureUrl</a>( <span class='pre'>userId, userPictures</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Get feed user picture url ...</div><div class='long'><p>Get feed user picture url</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>userId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>userPictures</span> : Object[]<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getPictureUserName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.notify.as.Utils'>sol.notify.as.Utils</span><br/><a href='source/lib_sol.notify.as.Utils.html#sol-notify-as-Utils-method-getPictureUserName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.notify.as.Utils-method-getPictureUserName' class='name expandable'>getPictureUserName</a>( <span class='pre'>userId, userPictures</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Get feed picture username ...</div><div class='long'><p>Get feed picture username</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>userId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>userPictures</span> : Object[]<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getPictures' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.notify.as.Utils'>sol.notify.as.Utils</span><br/><a href='source/lib_sol.notify.as.Utils.html#sol-notify-as-Utils-method-getPictures' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.notify.as.Utils-method-getPictures' class='name expandable'>getPictures</a>( <span class='pre'>users</span> ) : Object[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Get feed user pictures ...</div><div class='long'><p>Get feed user pictures</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>users</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getSordInfo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.notify.as.Utils'>sol.notify.as.Utils</span><br/><a href='source/lib_sol.notify.as.Utils.html#sol-notify-as-Utils-method-getSordInfo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.notify.as.Utils-method-getSordInfo' class='name expandable'>getSordInfo</a>( <span class='pre'>objGuid, sordMaps</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Get sord info ...</div><div class='long'><p>Get sord info</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objGuid</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>sordMaps</span> : Object[]<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getSordMap' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.notify.as.Utils'>sol.notify.as.Utils</span><br/><a href='source/lib_sol.notify.as.Utils.html#sol-notify-as-Utils-method-getSordMap' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.notify.as.Utils-method-getSordMap' class='name expandable'>getSordMap</a>( <span class='pre'>sordMap</span> ) : Object[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Get sord map ...</div><div class='long'><p>Get sord map</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sordMap</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getTemplateSordInstance' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.notify.as.Utils'>sol.notify.as.Utils</span><br/><a href='source/lib_sol.notify.as.Utils.html#sol-notify-as-Utils-method-getTemplateSordInstance' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.notify.as.Utils-method-getTemplateSordInstance' class='name expandable'>getTemplateSordInstance</a>( <span class='pre'></span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Creates template sord. ...</div><div class='long'><p>Creates template sord.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getTemplateTaskInstance' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.notify.as.Utils'>sol.notify.as.Utils</span><br/><a href='source/lib_sol.notify.as.Utils.html#sol-notify-as-Utils-method-getTemplateTaskInstance' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.notify.as.Utils-method-getTemplateTaskInstance' class='name expandable'>getTemplateTaskInstance</a>( <span class='pre'></span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Creates template task. ...</div><div class='long'><p>Creates template task.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getText' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.notify.as.Utils'>sol.notify.as.Utils</span><br/><a href='source/lib_sol.notify.as.Utils.html#sol-notify-as-Utils-method-getText' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.notify.as.Utils-method-getText' class='name expandable'>getText</a>( <span class='pre'>text, type, sordInfo</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Get text ...</div><div class='long'><p>Get text</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>text</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>type</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>sordInfo</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getUserName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.notify.as.Utils'>sol.notify.as.Utils</span><br/><a href='source/lib_sol.notify.as.Utils.html#sol-notify-as-Utils-method-getUserName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.notify.as.Utils-method-getUserName' class='name expandable'>getUserName</a>( <span class='pre'>userId</span> ) : string<span class=\"signature\"></span></div><div class='description'><div class='short'>Get user name ...</div><div class='long'><p>Get user name</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>userId</span> : String<div class='sub-desc'><p>ELO user</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>string</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul></div></div></div><div id='method-isOverTimeLimit' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.notify.as.Utils'>sol.notify.as.Utils</span><br/><a href='source/lib_sol.notify.as.Utils.html#sol-notify-as-Utils-method-isOverTimeLimit' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.notify.as.Utils-method-isOverTimeLimit' class='name expandable'>isOverTimeLimit</a>( <span class='pre'>node</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks if time is over limit ...</div><div class='long'><p>Checks if time is over limit</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>node</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-loadReportFlags' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.notify.as.Utils'>sol.notify.as.Utils</span><br/><a href='source/lib_sol.notify.as.Utils.html#sol-notify-as-Utils-method-loadReportFlags' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.notify.as.Utils-method-loadReportFlags' class='name expandable'>loadReportFlags</a>( <span class='pre'>userId</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Loads reporting flags for the specified user. ...</div><div class='long'><p>Loads reporting flags for the specified user.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>userId</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>reporting flags</p>\n</div></li></ul></div></div></div><div id='method-loadUserLanguage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.notify.as.Utils'>sol.notify.as.Utils</span><br/><a href='source/lib_sol.notify.as.Utils.html#sol-notify-as-Utils-method-loadUserLanguage' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.notify.as.Utils-method-loadUserLanguage' class='name expandable'>loadUserLanguage</a>( <span class='pre'>userId</span> ) : string<span class=\"signature\"></span></div><div class='description'><div class='short'>Loads language for the specified user. ...</div><div class='long'><p>Loads language for the specified user.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>userId</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>string</span><div class='sub-desc'><p>user language</p>\n</div></li></ul></div></div></div><div id='method-prepareFindTasksInfo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.notify.as.Utils'>sol.notify.as.Utils</span><br/><a href='source/lib_sol.notify.as.Utils.html#sol-notify-as-Utils-method-prepareFindTasksInfo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.notify.as.Utils-method-prepareFindTasksInfo' class='name expandable'>prepareFindTasksInfo</a>( <span class='pre'>userId, withGroups, withDeputies, withIndex</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Prepares find task infos. ...</div><div class='long'><p>Prepares find task infos.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>userId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>withGroups</span> : Boolean<div class='sub-desc'><p>Also include group term in the exam</p>\n</div></li><li><span class='pre'>withDeputies</span> : Boolean<div class='sub-desc'><p>Also include appointments in the exam</p>\n</div></li><li><span class='pre'>withIndex</span> : Boolean<div class='sub-desc'><p>The mail to be sent can also contain information about sord indexfields of the task</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>tasksInfo</p>\n</div></li></ul></div></div></div><div id='method-prepareTask' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.notify.as.Utils'>sol.notify.as.Utils</span><br/><a href='source/lib_sol.notify.as.Utils.html#sol-notify-as-Utils-method-prepareTask' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.notify.as.Utils-method-prepareTask' class='name expandable'>prepareTask</a>( <span class='pre'>userId, task, configReport</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Prepare task. ...</div><div class='long'><p>Prepare task.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>userId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>task</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>configReport</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-processAllUsers' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.notify.as.Utils'>sol.notify.as.Utils</span><br/><a href='source/lib_sol.notify.as.Utils.html#sol-notify-as-Utils-method-processAllUsers' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.notify.as.Utils-method-processAllUsers' class='name expandable'>processAllUsers</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Reads the complete ELO user list and checks for notification ...</div><div class='long'><p>Reads the complete ELO user list and checks for notification</p>\n</div></div></div><div id='method-processNotifyMail' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.notify.as.Utils'>sol.notify.as.Utils</span><br/><a href='source/lib_sol.notify.as.Utils.html#sol-notify-as-Utils-method-processNotifyMail' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.notify.as.Utils-method-processNotifyMail' class='name expandable'>processNotifyMail</a>( <span class='pre'>userId, configReport</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Creates mail to the user. ...</div><div class='long'><p>Creates mail to the user.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>userId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>configReport</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-processTask' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.notify.as.Utils'>sol.notify.as.Utils</span><br/><a href='source/lib_sol.notify.as.Utils.html#sol-notify-as-Utils-method-processTask' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.notify.as.Utils-method-processTask' class='name expandable'>processTask</a>( <span class='pre'>task, userId, configReport</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Process task. ...</div><div class='long'><p>Process task.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>task</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>userId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>configReport</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>flags if processing task successful</p>\n</div></li></ul></div></div></div><div id='method-processUser' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.notify.as.Utils'>sol.notify.as.Utils</span><br/><a href='source/lib_sol.notify.as.Utils.html#sol-notify-as-Utils-method-processUser' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.notify.as.Utils-method-processUser' class='name expandable'>processUser</a>( <span class='pre'>userId</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks for the specified user whether he has logged on\non notification by mail and executes it. ...</div><div class='long'><p>Checks for the specified user whether he has logged on\non notification by mail and executes it.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>userId</span> : String<div class='sub-desc'><p>User to be checked</p>\n</div></li></ul></div></div></div><div id='method-sendNotifyMail' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.notify.as.Utils'>sol.notify.as.Utils</span><br/><a href='source/lib_sol.notify.as.Utils.html#sol-notify-as-Utils-method-sendNotifyMail' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.notify.as.Utils-method-sendNotifyMail' class='name expandable'>sendNotifyMail</a>( <span class='pre'>userId, notifyTasks, notifyPosts, configReport</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Sends the notification mail. ...</div><div class='long'><p>Sends the notification mail.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>userId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>notifyTasks</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>notifyPosts</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>configReport</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloas":true,"singleton":true}});